#!/usr/bin/perl 

#  
#  All rights reserved.  This computer program and related documentation
#  is protected by copyright and distributed under licenses restricting
#  its use, copying, distribution and decompilation.  This computer
#  program and its documentation are CONFIDENTIAL and a TRADE SECRET
#  of EMULEX CORPORATION.  The receipt or possession of this program
#  or its documentation does not convey rights to reproduce or disclose
#  its contents, or to manufacture, use, or sell anything that it may
#  describe, in whole or in part, without the specific written consent
#  of EMULEX CORPORATION.  Any reproduction of this program without
#  the express written consent of EMULEX CORPORATION is a violation
#  of the copyright laws and may subject you to criminal prosecution.
# 

use Getopt::Std;

###getopts('f:');
####print "passed param = $opt_f\n";
###my $validation_id = $opt_f;

chdir "/sys/block";
while (<sd*>) {			# For each /sys/block/sd* device
  $serial_no = `scsi_id -g -s /block/$_`;
  chomp $serial_no;
  open(DEVID, "< $_/dev") || die "Cannot open `pwd`/$_/dev: $!\n";
  $devid = <DEVID>;		# Fetch device id (e.g. 8:32)
  close(DEVID);
  chomp $devid;
  $block{$devid} = $serial_no;
}

chdir "/dev";			# Fetch device major, minor numbers
while (<*>) {
  (undef, undef, undef, undef, undef, undef, $dev, undef) = stat($_);
  $major = $dev >> 8;		# Equivalent of fifth and sixth colums
  $minor = $dev & 0xff;		# of "ls -l /dev"
  $device = "$major:$minor";
  if (defined $block{$device}) {
###      $compare_serial_no = `echo "$block{$device}" | grep -i $validation_id | awk '{ print $/ }'`;  
       print "$block{$device}:";
       print "$_ \n";
#       if ($compare_serial_no) {
#         #print "match on $validation_id\n";
#         open (UDEVFILE, '>/usr/sbin/hbanyware/udev_device.txt');
#         select (UDEVFILE); $| = 1;
#         print (UDEVFILE "$_");
#         close (UDEVFILE);
#         exit;
#     }
  }
}
